/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.init;

import dev.toma.gunsrpg.resource.ammobench.AmmoBenchRecipe;
import dev.toma.gunsrpg.resource.blasting.BlastingRecipe;
import dev.toma.gunsrpg.resource.cooking.CookingRecipe;
import dev.toma.gunsrpg.resource.crafting.CulinaryRecipe;
import dev.toma.gunsrpg.resource.crafting.MedRecipe;
import dev.toma.gunsrpg.resource.crafting.SmithingRecipe;
import java.util.function.Supplier;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModRecipeSerializers {
    private static final DeferredRegister<IRecipeSerializer<?>> TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"gunsrpg");
    public static final RegistryObject<IRecipeSerializer<SmithingRecipe>> SMITHING_RECIPE_SERIALIZER = ModRecipeSerializers.register("smithing_table", SmithingRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<CookingRecipe>> COOKING_RECIPE_SERIALIZER = ModRecipeSerializers.register("cooking", CookingRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<CulinaryRecipe>> CULINARY_RECIPE_SERIALIZER = ModRecipeSerializers.register("culinary", CulinaryRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<MedRecipe>> MED_RECIPE_SERIALIZER = ModRecipeSerializers.register("medical_station", MedRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<BlastingRecipe>> BLASTING_RECIPE_SERIALIZER = ModRecipeSerializers.register("blasting", BlastingRecipe.Serializer::new);
    public static final RegistryObject<IRecipeSerializer<AmmoBenchRecipe>> AMMO_BENCH_RECIPE_SERIALIZER = ModRecipeSerializers.register("ammo_bench", AmmoBenchRecipe.Serializer::new);

    public static void subscribe(IEventBus bus) {
        TYPE.register(bus);
    }

    private static <T extends IRecipe<?>> RegistryObject<IRecipeSerializer<T>> register(String name, Supplier<IRecipeSerializer<T>> serializerSupplier) {
        return TYPE.register(name, serializerSupplier);
    }
}

